function FSDensityMapUtil.updateRoadCraftTrailerArea(workArea)
    local functionData = FSDensityMapUtil.functionCache.updateRoadCraftTrailerArea
    local startWorldX, _, startWorldZ = getWorldTranslation(workArea.start)
    local widthWorldX, _, widthWorldZ = getWorldTranslation(workArea.width)
    local heightWorldX, _, heightWorldZ = getWorldTranslation(workArea.height)
    if functionData == nil then
        local terrainRootNode = g_currentMission.terrainRootNode
        functionData = {}
        functionData.lastArea = 0
        functionData.lastTotalArea = 0
        local multiModifier = DensityMapMultiModifier.new()
        local modifier, filter
        for _, desc in pairs(g_fruitTypeManager:getFruitTypes()) do
            if desc.terrainDataPlaneId ~= nil then
                if modifier == nil then
                    modifier = DensityMapModifier.new(desc.terrainDataPlaneId,desc.startStateChannel, desc.numStateChannels, terrainRootNode)
                else
                    modifier:resetDensityMapAndChannels(desc.terrainDataPlaneId,desc.startStateChannel, desc.numStateChannels)
                end
                if filter == nil then
                    filter = DensityMapFilter.new(desc.terrainDataPlaneId,desc.startStateChannel, desc.numStateChannels, terrainRootNode)
                else
                    filter:resetDensityMapAndChannels(desc.terrainDataPlaneId,desc.startStateChannel, desc.numStateChannels)
                end
            filter:setValueCompareParams(DensityValueCompareType.BETWEEN, 2,desc.cutState)
            multiModifier:addExecuteSet(desc.cutState or 0, modifier, filter)
            end
        end
        local weedSystem = g_currentMission.weedSystem
            if weedSystem ~= nil then
                local weedTerrainDataPlaneId, weedStartChannel, weedNumChannels = weedSystem:getDensityMapData()
                modifier:resetDensityMapAndChannels(weedTerrainDataPlaneId, weedStartChannel, weedNumChannels)
                filter:resetDensityMapAndChannels(weedTerrainDataPlaneId, weedStartChannel, weedNumChannels)
                filter:setValueCompareParams(DensityValueCompareType.GREATER, 2)
                multiModifier:addExecuteSet(0, modifier, filter)
            end
            if g_currentMission.foliageSystem ~= nil then
                local decoFoliages = g_currentMission.foliageSystem:getDecoFoliages()
                local grassDesc = g_fruitTypeManager:getFruitTypeByIndex(FruitType.GRASS)
                for index, decoFoliage in pairs(decoFoliages) do
                    if decoFoliage.terrainDataPlaneId ~= nil then
                        -- reset the data plane and channels
                        modifier:resetDensityMapAndChannels(grassDesc.terrainDataPlaneId,grassDesc.startStateChannel, grassDesc.numStateChannels)
                        filter:resetDensityMapAndChannels(decoFoliage.terrainDataPlaneId,decoFoliage.startStateChannel, decoFoliage.numStateChannels)
                        -- limit to visible deco foliage only
                        filter:setValueCompareParams(DensityValueCompareType.GREATER, 0)
                        -- execute the modifier for data pixels that  -- match the filter
                        multiModifier:addExecuteSet(grassDesc.cutState, modifier, filter)
                    end
                end
            end
            functionData.multiModifier = multiModifier
            FSDensityMapUtil.functionCache.updateRotateMowerArea = functionData
    end
    DensityMapHeightUtil.clearArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    local multiModifier = functionData.multiModifier
    multiModifier:updateParallelogramWorldCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, DensityCoordType.POINT_POINT_POINT)
    multiModifier:execute(false)
end